from svggen.library import getComponent
from svggen.utils.tabs import *


def test_make_fixed_legs(display=False):
    def tabFace(length):
      f = Rectangle("tab", length, 10)
      f.renameEdges(edgeNames = ("tabedge", "e1", "slotedge", "e3"))
      return f

    d, h, l, bw = 9, 50, 28+19, 10

    # Load new component object from yaml definition
    # f = Component("FixedLegs.yaml")
    f = getComponent("FixedLegs")

    # Define free parameters
    f.setParameter("depth", d)
    f.setParameter("height", h)
    f.setParameter("length", l)
    f.setParameter("leg.beamwidth", bw)

    f.makeOutput("output/fixedlegs", tabFace = BeamTabs, slotDecoration=BeamSlotDecoration, display=display)


if __name__ == '__main__':
    test_make_fixed_legs(display=True)

