from svggen.library import getComponent
from svggen.library.Arduino import ArduinoProMini
from svggen.utils.dimensions import tgy1370a, fs90r


def test_make_seg(display=False):
    f = getComponent("FetchSeg", length=100, depth=12.2, width=57, height=20)

    f.setParameter("driveservo", fs90r)
    f.setParameter("gripperservo", tgy1370a)
    f.setParameter('controller', ArduinoProMini())

    f.makeOutput("output/seg", tree=True, display=display)


if __name__ == '__main__':
    test_make_seg(display=True)

