def prefix(s1, s2):
  if s1 and s2:
    return s1 + "." + s2
  return s1 or s2

def tryImport(module, attribute):
  try:
    mod = __import__(module, fromlist=[attribute])
    obj = getattr(mod, attribute)
    return obj
  except ImportError:
    mod = __import__("svggen.library." + module, fromlist=[attribute])
    obj = getattr(mod, attribute)
    return obj

def decorateGraph(face, decoration, offset=(0, 0), rotate=False, mode=None):
  try:
    dfaces = decoration.faces
  except AttributeError:
    dfaces = [decoration]

  if mode is None:
    mode = "hole"

  if rotate is False:
    rotate = 0
  elif rotate is True:
    rotate = -90

  for f in dfaces:
    transformDecorations(face, f.pts2d, offset=offset, rotate=rotate, mode=mode)

def transformDecorations(face, pts2d, offset=(0,0), rotate=0, flip=False, mode=None):
    from numpy import pi, sin, cos
    a = rotate * pi / 180.
    c = cos(a)
    s = sin(a)

    face.addDecoration(([
        (c*p[0] - s*p[1] + offset[0], s*p[0] + c*p[1] + offset[1])
        for p in pts2d], mode))

def copyDecorations(self, (ni1, (sc1, i1, p1a, p1b)), (ni2, (sc2, i2, p2a, p2b))):
  from numpy import arctan2, pi

  self.inheritInterface(ni1, (sc1, i1))
  self.inheritInterface(ni2, (sc2, i2))

  f1 = self.getInterface(ni1).face
  f2 = self.getInterface(ni2).face

  p1o = f1.pts2d[p1a]
  p1x = f1.pts2d[p1b]
  p2o = f2.pts2d[p2a]
  p2x = f2.pts2d[p2b]

  a1 = arctan2(p1x[1]-p1o[1], p1x[0]-p1o[0])
  a2 = arctan2(p2x[1]-p2o[1], p2x[0]-p2o[0])

  for pts, mode in f1.decorations:
      transformDecorations(
        f2,
        [(px - p1o[0], py - p1o[1]) for (px, py) in pts],
        offset = p2o,
        rotate = (a2-a1)*180/pi,
        mode = mode
      )
