from svggen.api.composables.graph.Face import Rectangle
from svggen.api.composables.graph.Drawing import Face
from svggen.api.composables.graph.DrawingEdge import Edge, Flex
from svggen.utils.mymath import pi, arctan2, norm
from svggen.utils.utils import prefix

class TabDrawing(Face):
  def __init__(self, w, t, noflap=False):
    if w > t:
      if (noflap or t > w/2 - 1): # HACK what's the right threshold?
        Face.__init__(self, 
          ((w,0), (w,t), (0,t)))
      else:
        Face.__init__(self, 
          ((w,0), (w+t,0), (w,t), (0,t), (-t,0)))
        self.edges['f0'] = Edge("f0", (0,0), (0,t), Flex())
        self.edges['f1'] = Edge("f1", (w,0), (w,t), Flex())
      self.transform(origin=(-w/2.0,-t/2.))
    else:
      t,w = w,t
      if (noflap or t > w/2 - 1): # HACK what's the right threshold?
        Face.__init__(self, 
          ((0,w), (t,w), (t,0)))
      else:
        Face.__init__(self, 
          ((0,w), (0,w+t), (t,w), (t,0), (0,-t)))
        self.edges['f0'] = Edge("f0", (0,0), (t,0), Flex())
        self.edges['f1'] = Edge("f1", (0,w), (t,w), Flex())
      self.transform(origin=(-t/2.0,-w/2.))

    self.edges.pop('e0')

class SlotDrawing(Face):
  def __init__(self, w, t, noflap=False):
    if w > t:
      Face.__init__(self, ((w+0.5, 0), (w+0.5, 0.5), (0, 0.5)))
      self.transform(origin=(-w/2. - 0.25, -t/2. - 0.25));
    else:
      t,w = w,t
      Face.__init__(self, ((0, w+0.5), (0.5, w+0.5), (0.5, 0)))
      self.transform(origin=(-t/2. - 0.25, -w/2. - 0.25));

def BeamTabSlotHelper(face, faceEdge, thick, widget, **kwargs):
    coords = face.edgeCoords(face.edgeIndex(faceEdge))
    globalOrigin = coords[0]
    theta = arctan2(coords[1][1]-coords[0][1], coords[1][0]-coords[0][0])
    length = norm((coords[1][1]-coords[0][1], coords[1][0]-coords[0][0]))

    try:
      frac = kwargs['frac']
    except:
      frac = 0.5
    try:
      noflap = kwargs['noflap']
    except:
      noflap = False

    # XXX TODO: Do the same thing with the other aspect ratio
    n = 0
    d = length*1.0 / (n*5+1)
    tw = thick * 3
    while (tw > thick * 2):
      n += 1
      d = length*1.0 / (n*5+1)
      tw = 2 * d

    t = widget(w=tw, t=thick*frac, noflap=noflap)
    try:
      if kwargs["flip"]:
        t.mirrorX()
    except: pass
    t.transform(angle=pi, origin=(-2 * d, thick/2.))
    try:
      if kwargs["mirror"]:
        t.mirrorY()
        t.transform(origin=(0, thick))
    except: pass

    for i in range(n):
      t.transform(origin=(d * 5, 0))
      for (name, edge) in t.edges.iteritems():
        e = edge.copy()
        e.transform(angle = theta, origin = globalOrigin)
        face.addDecoration((((e.x1, e.y1), (e.x2, e.y2)), e.edgetype.edgetype))
      try:
        if kwargs["alternating"]:
          t.mirrorY()
          t.transform(origin=(0, thick))
      except: pass

def BeamTabDecoration(face, edge, width, **kwargs):
  return BeamTabSlotHelper(face, edge, width, TabDrawing, **kwargs)
def BeamSlotDecoration(face, edge, width, **kwargs):
  return BeamTabSlotHelper(face, edge, width, SlotDrawing, **kwargs)

TABEDGE="tabedge"
SLOTEDGE="slotedge"
OPPEDGE="oppedge"
def BeamTabs(length, width, **kwargs):
    face = Rectangle('tab', length, width, 
                        edgeNames=[TABEDGE, "e1", OPPEDGE, "e3"],
                        recenter=False)
    BeamTabSlotHelper(face, TABEDGE, width, TabDrawing, **kwargs)
    face.MAINEDGE = TABEDGE
    return face

def BeamSlots(length, width, **kwargs):
    face = Rectangle('slot', length, width, 
                        edgeNames=[SLOTEDGE, "e1", OPPEDGE, "e3"],
                        recenter=False)
    BeamTabSlotHelper(face, SLOTEDGE, width, SlotDrawing, **kwargs)
    face.MAINEDGE = SLOTEDGE
    return face
