from svggen.api.component import Component
from svggen.utils.utils import prefix
from svggen.library import getComponent
import re

tabwidth = 8
class Modular:
  cx = {
        "F":  [["FL", "BL", "FL", {"angle": 0}],   ["FR", "BR", "FR", {"angle": 0}]],
        "B":  [["BL", "FL", "BL", {"angle": 0}],   ["BR", "FR", "BR", {"angle": 0}]],
        "L":  [["FL", "FR", "FL", {"angle": 180}], ["BL", "BR", "BL", {"angle": 180, "tabWidth": tabwidth}]],
        "R":  [["BR", "FR", "FL", {"angle": 180}], ["FR", "BR", "BL", {"angle": 180, "tabWidth": tabwidth}]],
        "Bx": [["BL", "FR", "FL", {"angle": 180}], ["BR", "BR", "BL", {"angle": 180, "tabWidth": tabwidth}]],
        "Fx": [["FR", "FR", "FL", {"angle": 180}], ["FL", "BR", "BL", {"angle": 180, "tabWidth": tabwidth}]],
       }

  def __init__(self, components, devices, brainlen, controller, yamlFile=None):
    component = Component("library/Core.yaml")
    self.initialize(component, "brain", "modular")

    if components:
      for (name, classname, position, params) in components:
        self.addComponent(position, (name, classname))
      self.make()

    if devices:
      for d in devices:
        (name, classname, position, index, interface, mountparams, _) = d
        self.c.addSubcomponent(name, classname, inherit=True)
        if interface:
          self.c.addConnection((name, interface),
                               self.mod["faces"][position][index], **mountparams)

    if yamlFile:
      self.c.toYaml(yamlFile)

    self.c.setParameter("brain.length", brainlen)
    self.c.setParameter('controller', controller)
    for (name, _, _, params) in components: 
      for key, value in params.iteritems():
        self.c.setParameter(prefix(name, key), value)
    for (name, _, _, _, _, _, params) in devices: 
      for key, value in params.iteritems():
        self.c.setParameter(prefix(name, key), value)

  def getComponent(self):
    return self.c

  def initialize(self, component, root, interface=None):
    if interface is None:
      interface = "modular"
    self.c = component

    self.mindepths = []
    self.depths = []

    self.minwidths = []
    self.widths = []

    self.lengths = []

    self.width = None
    self.length = None

    rootmods = self.getMods(self.c.getComponent(root), root, interface)
    self.mod = rootmods[0]
    for k, f in self.mod["faces"].iteritems():
      self.mod["faces"][k] = [(f[0], x) for x in f[1]]
    self.mod["faces"]["Fx"] = []
    self.mod["faces"]["Bx"] = []
    self.setParams(rootmods)
    self.components = {}

  def getMods(self, component, cname, interface=None):
    if interface is None:
      interface = "modular"
    mods = (
      component.getInterface(interface, transient=True).getModular(cname),
      component.getInterface(interface, transient=True).inherit(self.c, cname).getModular()
    )
    return mods

  def addMinParam(self, key, val):
    self.mod["parameters"][key].append(val)

  def extendFaces(self, mods, direction):
    for face in ("T", "B"):
      mfd = mods[0]["faces"][face]
      if mfd[1]:
        self.mod["faces"][face].extend([(mfd[0], x) for x in mfd[1]])

    if direction in ("F", "B"):
      for face in ("L", "R"):
        mfd = mods[0]["faces"][face]
        if mfd[1]:
          self.mod["faces"][face].extend([(mfd[0], x) for x in mfd[1]])
    else:
      mfd = mods[0]["faces"]["L"]
      if mfd[1]:
        self.mod["faces"][direction] = [(mfd[0], x) for x in mfd[1]]
      else:
        self.mod["faces"][direction] = []

  def setParams(self, mods):
    self.depths.append(mods[0]["parameters"]["depth"])
    self.mindepths.append(mods[1]["parameters"]["mindepth"])
    #print "deleting", mods[1]["parameters"]["depth"]["parameter"]
    self.c.delParameter(mods[1]["parameters"]["depth"]["parameter"])

    if self.length is None:
      #print "appending", mods[0]["parameters"]["width"]
      self.widths.append(mods[0]["parameters"]["width"])
      self.minwidths.append(mods[1]["parameters"]["minwidth"])
      #print "deleting", mods[1]["parameters"]["width"]["parameter"]
      self.c.delParameter(mods[1]["parameters"]["width"]["parameter"])
      self.lengths.append(mods[1]["parameters"]["length"])

    elif self.width is None:
      self.widths.append(mods[1]["parameters"]["width"])
      #print "deleting", mods[1]["parameters"]["length"]["parameter"]
      self.c.delParameter(mods[1]["parameters"]["length"]["parameter"])
      name = mods[0]["parameters"]["length"][0]
      val = mods[0]["parameters"]["length"][1]
      #print "constraining", (name, val["parameter"]), self.length
      self.c.addConstraint((name, val["parameter"]), *self.length)

    else:
      #print "deleting", mods[1]["parameters"]["length"]["parameter"]
      self.c.delParameter(mods[1]["parameters"]["length"]["parameter"])
      name = mods[0]["parameters"]["length"][0]
      val = mods[0]["parameters"]["length"][1]
      #print "constraining", (name, val["parameter"]), self.length
      self.c.addConstraint((name, val["parameter"]), *self.width)

  def combineParameters(self, fn, paramList, start=None):
    if start:
      params = list(start[0])
      fnstring = fn + "([" + start[1] + ", "
    else:
      params = []
      fnstring = fn + "(["
    for p in paramList:
      try:
        xstr = p.get("function", 'x')
        xstr = re.sub(r"\bx\b", r"x[%d]"%len(params), xstr)
        params.append(p["parameter"])
      except AttributeError:
        xstr = repr(p)
      fnstring += xstr + ","
    fnstring += "])"
    return (params, fnstring)

  def switchSection(self):
    if self.length is None:
      width = self.combineParameters("max", self.minwidths)
      for name, val in self.widths:
        #print "constraining", (name, val["parameter"]), width
        self.c.addConstraint((name, val["parameter"]), *width)
      self.length = self.combineParameters("sum", self.lengths)
      self.widths = [width]
    elif self.width is None:
      self.width = self.combineParameters("sum", self.widths[1:], self.widths[0])
    else:
      depth = self.combineParameters("max", self.mindepths)
      for name, val in self.depths:
        #print "constraining", (name, val["parameter"]), depth
        self.c.addConstraint((name, val["parameter"]), *depth)

  def connect(self, cmod, direction, flip=True, override=None):
    cx = override or Modular.cx[direction]
    for pair in cx:
      #print "addConnection", self.mod["edges"][pair[0]], cmod["edges"][pair[1]], pair[2]
      self.c.addConnection(self.mod["edges"][pair[0]], cmod["edges"][pair[1]], **pair[3])
      self.mod["edges"][pair[0]] = cmod["edges"][pair[2]]
    if flip:
      cx[0], cx[1]= cx[1], cx[0]
      cx[0][0], cx[1][0]= cx[1][0], cx[0][0]

  def addComponent(self, direction, (name, classname), interface=None):
    if direction not in Modular.cx:
      raise ValueError("Unknown direction " + direction)
    if direction not in self.components:
      self.components[direction] = []
    self.components[direction].append((name, classname, interface))

  def makeDirection(self, direction, flip=True, invert=False, first=None):
    for i, (name, classname, interface) in enumerate(self.components[direction]):
      if interface is None:
        interface = "modular"
      c = getComponent(classname)
      #print "adding subcomponent", (name, classname)
      self.c.addSubcomponent(name, classname, inherit=True, invert=invert)
      mods = self.getMods(c, name, interface)
      self.extendFaces(mods, direction)
      self.setParams(mods)
      self.connect(mods[0], direction, flip, i == 0 and first or None)

  def make(self):
    #print "*** center"
    for direction in ("F", "B"):
      if direction in self.components:
        self.makeDirection(direction, flip=False)
    self.switchSection()

    #XXX TODO: Make L + R same parity
    #print "*** sides"
    lens = {"L": 0, "R": 0}
    for direction in ("L", "R"):
      if direction in self.components:
        lens[direction] = len(self.components[direction])
        self.makeDirection(direction)
    self.switchSection()

    if lens["L"] % 2 == 0 and lens["R"] % 2 == 0:
      override = {
        "Bx": [["BR", "FR", "FL", {"angle": 90}], ["BL", "BR", "BL", {"angle": 90, "tabWidth": tabwidth, "swap": True}]],
        "Fx": [["FL", "FR", "FL", {"angle": 90}], ["FR", "BR", "BL", {"angle": 90, "tabWidth": tabwidth, "swap": True}]],
      }
    elif lens["L"] % 2 == 1 and lens["R"] % 2 == 1:
      override = {
        "Bx": [["BL", "BR", "BL", {"angle": 90}], ["BR", "FR", "FL", {"angle": 90, "tabWidth": tabwidth, "swap": True}]],
        "Fx": [["FR", "BR", "BL", {"angle": 90}], ["FL", "FR", "FL", {"angle": 90, "tabWidth": tabwidth, "swap": True}]],
      }
      for cx in (Modular.cx[d] for d in ("Fx", "Bx")):
        cx[0], cx[1]= cx[1], cx[0]
        cx[0][0], cx[1][0]= cx[1][0], cx[0][0]
    else:
      print "Need L and R to be same parity"

    #print "*** frontback"
    for direction in ("Fx", "Bx"):
      if direction in self.components:
        self.makeDirection(direction, invert=True, first=override[direction])
    self.switchSection()
