
@@declare
#include "string_functions.h"
#define numPins @numPins

// Define pin types
#define DO 0
#define DI 1
#define AO 2
#define AI 3
#define PO 4 // PWM Output
#define PI 5 // PWM Input
#define SO 6 // Servo Output
#define SI 7 // Servo Input
// Define protocol types
#define PROTOCOL_DIRECT 0
#define PROTOCOL_BLUETOOTH 1

@@method<void robotSetup()>
void robotSetup()
{
  robotPrintSetupDebug(9600);
  // Set each pin to the correct mode
  for(int pinIndex = 0; pinIndex < numPins; pinIndex++)
  {
    int controllerPin = getControllerPin(pinIndex);
    if(controllerPin >= 0 && getPinMateType(pinIndex) >= 0)
      setPinMode(controllerPin, getPinMateType(pinIndex));
  }
}

@@method<void robotLoop()>
void robotLoop()
{
  robotPrintlnDebug();
}

@@declare
#define getPinMateType(pinIndex)(getPinType(pinIndex) == DO ? DI : (        \
                                 getPinType(pinIndex) == DI ? DO : (        \
                                 getPinType(pinIndex) == PO ? PI : (        \
                                 getPinType(pinIndex) == PI ? PO : (        \
                                 getPinType(pinIndex) == AO ? AI : (        \
                                 getPinType(pinIndex) == AI ? AO : (        \
                                 getPinType(pinIndex) == SO ? SI : (        \
                                 getPinType(pinIndex) == SI ? SO : (        \
                                 -1)))))))))


@@declare
#define set(pin) (setDO(pin, 1))
#define clear(pin) (setDO(pin, 0))
#define threshAI(pin, threshold) (readAI(pin) > threshold)

@@declare
<@
#define PRINT_DEBUG 1
#if PRINT_DEBUG == 1
#define robotPrintDebug(toPrint) robotPrint(toPrint)
#define robotPrintlnDebug(toPrint) robotPrintln(toPrint)
#define robotPrintSetupDebug(baud) robotPrintSetup(baud)
#else
#define robotPrintDebug(toPrint)
#define robotPrintlnDebug(toPrint)
#define robotPrintSetupDebug(baud)
#endif
@>









