
@@declare
#define numMicrophones @deviceTypeCount
int microphonePins[numMicrophones];
int microphoneCalibration[numMicrophones];

@@insert<void robotSetup()>
microphonePins[@deviceTypeIndex] = @portID<sensorSignal>;
calibrateMicrophone(@deviceTypeIndex);

@@insert<char* getData(int sourceID, int destID)><@prepend>
if(sourceID == @dataOutputID<touched>)
{
  itoa(detectNoise(@deviceTypeIndex), outputData, 10);
  validGetData = true;
  return outputData;
}

@@method<void calibrateMicrophone(int sensorIndex)>
void calibrateMicrophone(int sensorIndex)
{
  robotPrintnDebug("Keep noise low: calibrating microphone "); robotPrintDebug(sensorIndex); robotPrintDebug("... ");
  unsigned long start = millis();
  microphoneCalibration[sensorIndex] = readAI(microphonePins[sensorIndex]);
  while(millis() - start < 1000)
    microphoneCalibration[sensorIndex] = (microphoneCalibration[sensorIndex] + readAI(microphonePins[sensorIndex]))/2;
  robotPrintlnDebug("done");
}

@@method<bool detectNoise(int sensorIndex)>
bool detectNoise(int sensorIndex)
{
  robotPrintDebug("Reading microphone "); robotPrintDebug(sensorIndex); robotPrintDebug(": ");
  //unsigned long start = millis();
  //while(millis() - start < 100)
  for(int i = 0; i < 10; i++)
  {
    int val = readAI(microphonePins[sensorIndex]);
    if(val < microphoneCalibration[sensorIndex]*0.8 || val > microphoneCalibration[sensorIndex]*1.2)
    {
      robotPrintlnDebug("1");
      return true;
    }
  }
  robotPrintlnDebug("0");
  return false;
}
