
@@declare
#define numDistanceSensors @deviceTypeCount
int distanceSensorPins[numDistanceSensors];
int distanceSensorThresholds[numDistanceSensors];

@@insert<void robotSetup()>
distanceSensorPins[@deviceTypeIndex] = @portID<signal>;
distanceSensorThresholds[@deviceTypeIndex] = 512;
calibrateDistanceSensor(@deviceTypeIndex);

@@method<int readDistanceSensor(int sensorIndex)>
int readDistanceSensor(int sensorIndex)
{
  int res = readAI(distanceSensorPins[sensorIndex]);
  robotPrintDebug("Reading distance sensor "); robotPrintDebug(sensorIndex);
  robotPrintDebug(": "); robotPrintlnDebug(res);
  return res;
}

@@method<bool threshDistanceSensor(int sensorIndex)>
bool threshDistanceSensor(int sensorIndex)
{
  bool res = readAI(distanceSensorPins[sensorIndex]) > distanceSensorThresholds[sensorIndex];
  robotPrintDebug("Thresholding distance sensor "); robotPrintDebug(sensorIndex);
  robotPrintDebug(": "); robotPrintlnDebug(res);
  return res;
}

@@insert<char* getData(int sourceID, int destID)><@prepend>
if(sourceID == @dataOutputID<curValue>)
{
  itoa(readDistanceSensor(@deviceTypeIndex), outputData, 10);
  validGetData = true;
  return outputData;
}
if(sourceID == @dataOutputID<nearWall>)
{
  itoa(threshDistanceSensor(@deviceTypeIndex), outputData, 10);
  validGetData = true;
  return outputData;
}

@@method<void calibrateDistanceSensor(int sensor)>
void calibrateDistanceSensor(int sensor)
{
  robotPrintlnDebug("Place distance sensor at nearest position");
  delay(3000);
  int max = 0;
  for(int i = 0; i < 5; i++, delay(50))
    max += readDistanceSensor(sensor);
  max /= 5;
  robotPrintlnDebug("Place distance sensor at farthest position");
  delay(3000);
  int min = 0;
  for(int i = 0; i < 5; i++, delay(50))
    min += readDistanceSensor(sensor);
  min /= 5;
  distanceSensorThresholds[sensor] = (max+min)/2;
  delay(500);
}