

@@declare
#include "OneWireSerial.h"
#define numColorSensors @deviceTypeCount
OneWireSerial colorSensorSerials[numColorSensors];
int colorSensorReadings[numColorSensors][3 /* red, green, blue */];

@@insert<void robotSetup()>
colorSensorSerials[@deviceTypeIndex] = OneWireSerial(getControllerPin(@portID<signal>));
colorSensorSerials[@deviceTypeIndex].begin(4800);
resetColorSensor(@deviceTypeIndex);

@@insert<char* getData(int sourceID, int destID)><@prepend>
if(sourceID == @dataOutputID<red>)
{
  readColorSensor(@deviceTypeIndex);
  itoa(colorSensorReadings[@deviceTypeIndex][0], outputData, 10);
  validGetData = true;
  return outputData;
}
if(sourceID == @dataOutputID<green>)
{
  readColorSensor(@deviceTypeIndex);
  itoa(colorSensorReadings[@deviceTypeIndex][1], outputData, 10);
  validGetData = true;
  return outputData;
}
if(sourceID == @dataOutputID<blue>)
{
  readColorSensor(@deviceTypeIndex);
  itoa(colorSensorReadings[@deviceTypeIndex][2], outputData, 10);
  validGetData = true;
  return outputData;
}

@@method<void readColorSensor(int sensor)>
void readColorSensor(int sensor)
{
  char buffer[32];
  colorSensorSerials[@deviceTypeIndex].listen();
  unsigned long timeout = 100;
  unsigned long start = millis();
  while(!colorSensorSerials[@deviceTypeIndex].available() && millis() - start < timeout);
  if(colorSensorSerials[@deviceTypeIndex].available() > 0)
  {
    // Wait for a $ character, then read three 3 digit hex numbers
    buffer[0] = colorSensorSerials[@deviceTypeIndex].read();
    if(buffer[0] == '$')
    {
      for(int i = 0; i < 9; i++)
      {
        while (colorSensorSerials[@deviceTypeIndex].available() == 0);     // Wait for next input character
        buffer[i] = colorSensorSerials[@deviceTypeIndex].read();
        if (buffer[i] == '$')               // Return early if $ character encountered
          return;
      }
      // Parse data into integers
      sscanf(buffer, "%3x%3x%3x", &colorSensorReadings[0], &colorSensorReadings[1], &colorSensorReadings[2]);
      delay(10);
    }
  }
}

@@method<void resetColorSensor(int sensor)>
void resetColorSensor(int sensor)
{
  delay(200);
  setPinMode(getControllerPin(@portID<signal>), DO);
  setDO(@portID<signal>, 0);
  setPinMode(getControllerPin(@portID<signal>), DI);
  while (readDI(@portID<signal>) != 1);
  setPinMode(@portID<signal>, DO);
  setDO(@portID<signal>, 0);
  delay(80);
  setPinMode(@portID<signal>, DI);
  delay(200);
  colorSensorSerials[@deviceTypeIndex].print("= (00 $ m) !"); // Loop print values, see ColorPAL documentation
}

