
@@declare
#define numBuzzers @deviceTypeCount
int buzzerPins[numBuzzers];

@@insert<void robotSetup()>
buzzerPins[@deviceTypeIndex] = @portID<signal>;
turnOffBuzzer(@deviceTypeIndex);

@@method<void turnOnBuzzer(int buzzerIndex)>
void turnOnBuzzer(int buzzerIndex)
{
  setDO(buzzerPins[buzzerIndex], 1);
  robotPrintDebug("Set buzzer "); robotPrintDebug(buzzerIndex);
  robotPrintDebug(" to "); robotPrintlnDebug(1);
}

@@method<void turnOffBuzzer(int buzzerIndex)>
void turnOffBuzzer(int buzzerIndex)
{
  setDO(buzzerPins[buzzerIndex], 0);
  robotPrintDebug("Set buzzer "); robotPrintDebug(buzzerIndex);
  robotPrintDebug(" to "); robotPrintlnDebug(0);
}

@@insert<void processData(const char* data, int sourceID, int destID)><@prepend>
if(destID == @dataInputID)
{
  int value = (int) atof(data);
  if(value)
    turnOnBuzzer(@deviceTypeIndex);
  else
    turnOffBuzzer(@deviceTypeIndex);
}