from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.FacePort import FacePort
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.ModularPort import ModularPort
import svggen.utils.mymath as math

class Wing(Component):

  _test_params = {
    'bodylength': 50,
    'wingspan': 100,
    'wingtip': 10,
    'thickness': 10,
    'flip': False,
  }


  def define(self):
    self.addParameter("bodylength")
    self.addParameter("wingspan")
    self.addParameter("wingtip")
    self.addParameter("thickness")
    self.addParameter("flip", False)

    self.addInterface("base", EdgePort(self, None))
    self.addInterface("tip", EdgePort(self, None))

    self.addInterface("basetop", EdgePort(self, None))
    self.addInterface("tiptop", EdgePort(self, None))

    self.addInterface("bottom", FacePort(self, None, None))

  def assemble(self):
    graph = Graph()

    bodylength = self.getParameter("bodylength")
    wingspan = self.getParameter("wingspan")
    wingtip = self.getParameter("wingtip")
    thickness = self.getParameter("thickness")
    flip = self.getParameter("flip")

    if flip:
        bodylength, wingtip = wingtip, bodylength

    graph.addFace(Face("", (
      (wingspan, 0), (wingspan, bodylength), (0, wingtip), (0,0)
    ), recenter=False), "bottom")

    graph.attachFace("bottom.e2", Face("", (
      (wingspan, 0), (wingspan, wingtip/2.+thickness), (wingspan, wingtip+thickness), (0, bodylength+thickness), (0, bodylength/2.+thickness), (0,0)
    )), "e3", prefix="top", angle = 170)

    graph.addTab("bottom.e0", "top.e0", angle= 170, width=thickness)

    self.composables["graph"] = graph

    if flip:
        self.setInterface("base", EdgePort(self, "bottom.e3"))
        self.setInterface("tip", EdgePort(self, "bottom.e1"))
        self.setInterface("basetop", EdgePort(self, "top.e1"))
        self.setInterface("tiptop", EdgePort(self, "top.e5"))
    else:
        self.setInterface("base", EdgePort(self, "bottom.e1"))
        self.setInterface("tip", EdgePort(self, "bottom.e3"))
        self.setInterface("basetop", EdgePort(self, "top.e5"))
        self.setInterface("tiptop", EdgePort(self, "top.e1"))

    self.setInterface("bottom", FacePort(self, graph, "bottom"))

if __name__ == "__main__":
  b = Wing()
  b._make_test()

