from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class VLeg(Component):

    _test_params = {
        'height': 40,
        'width': 50,
        'thickness': 10,
        'taper': 0.5,
    }

    def define(self):
        self.addParameter("height", 40, paramtype="length")
        self.addParameter("width", 50, paramtype="length")
        self.addParameter("thickness", 10, paramtype="length")
        self.addParameter("taper", 0.5, paramtype="ratio")

        self.addInterface("leftedge", EdgePort(self, None))
        self.addInterface("topedge", EdgePort(self, None))
        self.addInterface("rightedge", EdgePort(self, None))

    def assemble(self):
        h = self.getParameter("height")
        w = self.getParameter("width")
        t = self.getParameter("thickness")
        r = self.getParameter("taper") * t

        s = Face("", ((h, 0), (h, w), (0, w), (0, w-r), (h-t, w-t), (h-t, t), (0, r), (0,0)))

        graph = Graph()
        graph.addFace(s, "leg")

        self.composables["graph"] = graph

        self.setInterface("leftedge", EdgePort(self, "leg.e0"))
        self.setInterface("topedge", EdgePort(self, "leg.e1"))
        self.setInterface("rightedge", EdgePort(self, "leg.e2"))

if __name__ == "__main__":
    h = VLeg()
    h._make_test()

