from svggen.api.component import Component
from svggen.api.ports.EdgePort import EdgePort
from svggen.utils.dimensions import tgy1370a
from svggen.api.Function import Function

class TwoServoMount(Component):

  _test_params = {
    'servo': tgy1370a,
    'length': 70,
  }

  def define(self):
    self.addSubcomponent("beam", "RectBeam")
    self.addSubcomponent("hole1", "Cutout")
    self.addSubcomponent("hole2", "Cutout")

    self.addParameter("length")
    self.addParameter("servo")
    self.addParameter("depth")
    self.addParameter("width")
    self.addParameter("phase", 0)
    self.addParameter("faces", None)
    self.addParameter("offset", None)

    ### Set specific relationships between parameters
    # self.addConstraint(("beam", "width"), "servo", 'x.getParameter("motorheight")')
    # self.addConstraint(("beam", "depth"), "servo", 'x.getParameter("motorwidth")')
    self.addConstraint(("beam", "length"), "length")
    self.addConstraint(("beam", "width"), "width")
    self.addConstraint(("beam", "depth"), "depth")
    self.addConstraint(("beam", "phase"), "phase")

    self.addConstraint(("beam", "minwidth"), "servo", 'x.getParameter("motorheight")')
    self.addConstraint(("beam", "mindepth"), "servo", 'x.getParameter("motorwidth")')
    self.addConstraint(("beam", "minlength"), "servo", 'x.getParameter("motorlength") * 2 + x.getParameter("shoulderlength") * 2') 

    self.addConstraint(("beam", "faces"), "faces")
    self.addConstConstraint(("beam", "noflap"), True)

    self.addConstraint(("hole1", "dx"), "servo", 'x.getParameter("motorwidth") * 0.99')
    self.addConstraint(("hole1", "dy"), "servo", 'x.getParameter("motorlength")')
    self.addConstraint(("hole2", "dx"), "servo", 'x.getParameter("motorwidth") * 0.99')
    self.addConstraint(("hole2", "dy"), "servo", 'x.getParameter("motorlength")')

    self.addConnection(("beam", "face3"),
                       ("hole1", "hole"),
                       mode="hole", offset=Function(params="offset"))
    self.addConnection(("beam", "face1"),
                       ("hole2", "hole"),
                       mode="hole", offset=Function(params="offset"))

    self.inheritAllInterfaces("beam", prefix=None)

  def modifyParameters(self):
    # XXX TODO: Make sure servo can fit
    ml = self.getParameter("servo").getParameter("motorlength") * 2 + self.getParameter("servo").getParameter("shoulderlength") * 2
    try:
      l = max(self.getParameter("length"), ml)
    except KeyError:
      l = ml

    ml = self.getParameter("servo").getParameter("motorlength")
    sl = self.getParameter("servo").getParameter("shoulderlength")
    ho = self.getParameter("servo").getParameter("hornoffset")

    dy = l/2. - ml/2. - sl
    self.setParameter("offset", (0, dy))
    print "offset", dy

if __name__ == "__main__":
  f = TwoServoMount()
  f._make_test()

