from svggen.api.ElectricalComponent import ElectricalComponent
from svggen.api.ports.DigitalOutputPort import DigitalOutputPort
from svggen.api.ports.Ground import Ground

__author__ = 'Joseph'

class TouchSensorDevice(ElectricalComponent):
  def define(self):
    ElectricalComponent.define(self)
    self.addInterface('sensorSignal', DigitalOutputPort(parent=self, name='sensorSignal'))
    self.addInterface('ground', Ground(parent=self, name='ground', voltage=0))

  def assemble(self):
    ElectricalComponent.assemble(self)
    ElectricalComponent.setControllerPins(self)
