from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle, RightTriangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class Tail(Component):

    _test_params = {
        'height': 60,
        'depth': 20,
        'width': 80,
    }

    def define(self):
        self.addParameter("height")
        self.addParameter("depth")
        self.addParameter("width")
        self.addParameter("flapwidth", 0.2)
        self.addParameter("tailwidth", 1./3)

        self.addInterface("topedge", EdgePort(self, None))
        self.addInterface("flapedge", EdgePort(self, None))

    def assemble(self):
        h = self.getParameter("height")
        w = self.getParameter("width")
        d = self.getParameter("depth")

        flapwidth = self.getParameter("flapwidth")
        tailwidth = self.getParameter("tailwidth")
        lr0 = (1-flapwidth)/2.
        lr1 = 1-lr0
        lt0 = (1-tailwidth)/2.
        lt1 = 1-lt0

        s = Face("", ((w*lr0, 0), (w*lr1, 0), (w, 0), (w, 0.1), (0, 0.1), (0, 0)))
        t = Face("", ((w*lr0, 0), (w*lr0, d), (w*lr1, d), (w*lr1, 0), (w, 0), (w*lt1, h), (w*lt0, h), (0, 0)))
        f1 = RightTriangle("", h, w*lt0)
        f2 = RightTriangle("", w*lt0, h)

        graph = Graph()
        graph.addFace(s, "spacer")
        graph.attachFace("spacer.e2", t, "e0", "tail", angle=0)
        graph.mergeEdge("spacer.e0", "tail.e4", angle=0)
        graph.attachFace("tail.e5", f2, "e1", "f1", angle=-135)
        graph.attachFace("tail.e7", f1, "e1", "f2", angle=-135)

        self.composables["graph"] = graph

        self.setInterface("topedge", EdgePort(self, "spacer.e4"))
        self.setInterface("flapedge", EdgePort(self, "tail.e2"))

if __name__ == "__main__":
    h = Tail()
    h._make_test()

