from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle, RegularNGon as Shape
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.utils.mymath import sin, deg2rad


class Stool(Component):

    _test_params = {
        'height': 60,
        'legs': 3,
        'radius': 20,
        'angle': 80,
    }

    def define(self):
        self.addParameter("height", 60, paramtype="length")
        self.addParameter("legs", 3, paramtype="count")
        self.addParameter("radius", 20, paramtype="length")
        self.addParameter("angle", 80, paramtype="angle")

    def assemble(self):
        hp = self.getParameter("height")
        lp = self.getParameter("legs")
        rp = self.getParameter("radius")
        ap = self.getParameter("angle")

        # XXX TODO: add min and max values to Parameter objects
        h = max(hp, 10)
        n = max(lp, 2) * 2
        e = max(2*rp*sin(deg2rad(180./n)), 10)

        graph = Graph()
        graph.addFace(Shape("", n, e), "seat")

        for i in range(0, n/2):
            s = Rectangle("", e, h)
            graph.attachFace("seat.e%d" % (2*i), s, "e0", "leg%d" % i, angle=ap)

        self.composables["graph"] = graph

if __name__ == "__main__":
    from svggen.api.composables.graph.Joint import FingerJoint
    h = Stool()
    h._make_test(thickness=4, joint=FingerJoint(thickness=4))

