from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort
import svggen.utils.mymath as np


class SpokedWheel(Component):

  _test_params = {
    'n': 60,
    'radius': 30,
    'spokes': 5,
    'depth': 2,
  }

  def define(self):
    self.addParameter("n")
    self.addParameter("radius")
    self.addParameter("spokes")
    self.addParameter("depth")
    self.addParameter("label", "graph")

    self.addInterface("e0", EdgePort(self, None))
    self.addInterface("face", FacePort(self, None, None))

  def assemble(self):
    n = self.getParameter("n")
    l = self.getParameter("radius")
    s = self.getParameter("spokes")
    n = int(n/s)
    d = self.getParameter("depth")
    label = self.getParameter("label")

    graph = Graph()

    print n, s
    faces = []
    for i in range(s):
	pts = []
	dt = (2 * np.pi / s / n)
	for i in range(n+1):
	    pts.append((l*np.cos(i * dt), l*np.sin(i * dt)))
        pts.append((0,0))
        f1 = Face("", pts)
        r1 = Rectangle("", l, d)
        r2 = Rectangle("", l, d)
        faces.append((f1, r1, r2))

    fromEdge = None
    en = "e%d" % (n+1)
    for i in range(len(faces)):
        graph.attachFace(fromEdge, faces[i][0], 'e0', prefix="f%d"%i)
        graph.attachFace("f%d.%s" % (i, en), faces[i][1], "e0" , prefix="r1%d"%i, angle = -180)
        graph.attachFace("r1%d.e2" % i, faces[i][2], "e0" , prefix="r2%d"%i, angle = 180)
        fromEdge = "r2%d.e2" % i
    graph.mergeEdge(fromEdge, "f0.e0")

    self.composables[label] = graph

    self.setInterface("e0", EdgePort(self, "e0"))
    self.setInterface("face", FacePort(self, graph, "r"))

if __name__ == "__main__":
    h = SpokedWheel()
    h._make_test()

