from svggen.api.component import Component
from svggen.api.composables.GraphComposable import Graph
from svggen.api.composables.graph.Face import Face
from svggen.api.ports.EdgePort import EdgePort
from svggen.utils.mymath import cumsum


def isclose(a, b, rel_tol=1e-09, abs_tol=0.0):
    return abs(a-b) <= max(rel_tol * max(abs(a), abs(b)), abs_tol)

class SplitEdge(Component):

    _test_params = {
        'toplength': (10, 30, 60),
        'botlength': (80, 20),
        'tolerance': 10,
    }

    def define(self):
        self.addParameter("toplength")
        self.addParameter("botlength")
        self.addParameter("tolerance", 0)

        for i in range(100):
          self.addInterface("topedge%d" % i, EdgePort(self, None))
          self.addInterface("botedge%d" % i, EdgePort(self, None))

    def assemble(self):
        t = cumsum(self.getParameter("toplength")[::-1])
        b = cumsum(self.getParameter("botlength")[::-1])
        if not isclose(t[-1], b[-1]):
          raise ValueError("SplitEdge lengths not equal: %s <> %s" % (repr(t), repr(b)))

        TOL = self.getParameter("tolerance")
        pts = [(x, 0) for x in b]
        pts += [(x, TOL) for x in t[::-1]]
        pts += [(0, TOL), (0,0)]

        graph = Graph()
        graph.addFace(Face("split", pts))
        self.composables["graph"] = graph

        tops = ["e%d" % (len(b) + d + 1) for d in range(len(t))]
        bots = ["e%d" % d for d in range(len(b))[::-1]]
        for i, topedge in enumerate(tops):
          self.setInterface("topedge%d" % i, EdgePort(self, topedge))
        for i, botedge in enumerate(bots):
          self.setInterface("botedge%d" % i, EdgePort(self, botedge))

if __name__ == "__main__":
    e = SplitEdge()
    e._make_test()

