from svggen.api.component import Component
from svggen.api.ports.EdgePort import EdgePort
from svggen.utils.dimensions import tgy1370a
from svggen.api.Function import Function


class ServoMount(Component):

  _test_params = {
    'servo': tgy1370a,
    'flip': True,
  }

  def define(self):
    self.addSubcomponent("beam", "RectBeam")
    self.addSubcomponent("hole", "Cutout")

    self.addParameter("length")
    self.addParameter("servo")
    self.addParameter("flip", False)
    self.addParameter("depth")
    self.addParameter("width")
    self.addParameter("phase", 0)
    self.addParameter("center", True)
    self.addParameter("faces", None)
    self.addParameter("shift", 0)
    self.addParameter("offset", None)

    ### Set specific relationships between parameters
    # self.addConstraint(("beam", "width"), "servo", 'x.getParameter("motorheight")')
    # self.addConstraint(("beam", "depth"), "servo", 'x.getParameter("motorwidth")')
    self.addConstraint(("beam", "length"), "length")
    self.addConstraint(("beam", "width"), "depth")
    self.addConstraint(("beam", "depth"), "width")

    self.addConstraint(("beam", "minlength"), "servo", 'x.getParameter("motorlength") + x.getParameter("shoulderlength") * 2')
    self.addConstraint(("beam", "minwidth"), "servo", 'x.getParameter("motorwidth")')
    self.addConstraint(("beam", "mindepth"), "servo", 'x.getParameter("motorheight")')

    self.addConstraint(("beam", "phase"), "phase")
    self.addConstraint(("beam", "faces"), "faces")
    self.addConstConstraint(("beam", "noflap"), True)

    self.addConstraint(("hole", "dx"), "servo", 'x.getParameter("motorwidth") * 0.99')
    self.addConstraint(("hole", "dy"), "servo", 'x.getParameter("motorlength")')

    self.inheritAllInterfaces("beam", prefix=None)
    self.addConnection(("beam", "face2"),
                       ("hole", "hole"),
                       mode="hole", offset=Function(params="offset"))
    
  def modifyParameters(self):
    # XXX TODO: Make sure servo can fit
    try:
      minl = self.getParameter("minlength")
    except KeyError:
      # XXX duplicated mindepth value
      minl = self.getParameter("servo").getParameter("motorlength") + self.getParameter("servo").getParameter("shoulderlength") * 2

    try:
      l = max(self.getParameter("length"), minl)
    except KeyError:
      l = minl

    ml = self.getParameter("servo").getParameter("motorlength")
    sl = self.getParameter("servo").getParameter("shoulderlength")
    ho = self.getParameter("servo").getParameter("hornoffset")

    s = self.getParameter("shift")

    dy = l/2. - ml/2. - sl
    if self.getParameter("center"):
      dy = min(dy, ml/2. - ho)
    dy -= s
    if self.getParameter("flip"):
      dy = -dy

    self.setParameter("offset", (0, dy))


if __name__ == "__main__":
  f = ServoMount()
  f._make_test()

