from svggen.api.component import Component
from svggen.utils import tabs
from svggen.utils.dimensions import tgy1370a
from svggen.library.Arduino import ArduinoProMini
from svggen.api.Function import Function



class SegSheath(Component):

  _test_params = {
    'controller': ArduinoProMini(),
    'length': 40,
    'width': 35,
    'depth': 20,
    'height': 50
  }

  def define(self):
    self.addSubcomponent("beam", "RectBeam", inherit=True, prefix=None)
    self.addSubcomponent("tail", "Rectangle")
    self.addSubcomponent("header", "Header")
    self.addSubcomponent("prog", "Cutout")
    self.addSubcomponent("rwire", "Cutout")
    self.addSubcomponent("lwire", "Cutout")

    self.addParameter("height")
    self.addParameter("controller")

    def getBrainParameter(p):
      return "controller", "x.getDimension('%s')" % p

    self.addConstraint(("header", "nrows"), *getBrainParameter("nrows"))
    self.addConstraint(("header", "ncols"), *getBrainParameter("ncols"))
    self.addConstraint(("header", "rowsep"), *getBrainParameter("rowsep"))
    self.addConstraint(("header", "colsep"), *getBrainParameter("colsep"))

    self.addConstConstraint(("beam", "faces"), range(4))

    self.addConstConstraint(("prog", "dx"), 19)
    self.addConstConstraint(("prog", "dy"), 6)

    self.addConstConstraint(("rwire", "dx"), 10)
    self.addConstConstraint(("rwire", "dy"), 4)
    self.addConstConstraint(("lwire", "dx"), 10)
    self.addConstConstraint(("lwire", "dy"), 4)

    self.addConstraint(("tail", "l"), "length")
    self.addConstraint(("tail", "w"), ("height", "depth"), "x[0] - x[1]/2.")

    self.inheritAllInterfaces("beam", prefix=None)

    self.addConnection(("beam", "tabedge"),
                       ("tail", "t"),
                       angle=0)

    self.addConnection(("beam", "face2"),
                       ("header", "mount"),
                       mode="hole", rotate=True, offset=Function(params=("width", "controller"), fnstring="(-0.5 * (x[0]-x[1].getDimension('length')), 0)"))

    self.addConnection(("beam", "face0"),
                       ("prog", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("width"), fnstring="(0.5 * x - 3, 0)"))

    self.addConnection(("beam", "face1"),
                       ("rwire", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("depth"), fnstring="(x/2. - 3, -15)"))

    self.addConnection(("beam", "face1"),
                       ("lwire", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("depth"), fnstring="(x/2. - 3, 15)"))

  def assemble(self):
    ### Assemble the object

    ### XXX hack to get 3 faces along an edge
    graph = self.composables["graph"]

    tabWidth = self.getParameter("depth")
    tab = tabs.BeamTabs(self.getParameter("length"), tabWidth, mirror=True)

    graph.attachFace(self.getInterfaces("beam", "slotedge").getEdges()[0],
                     tab, "tabedge", prefix="beamtab", angle=90)
    tabs.BeamSlotDecoration(graph.getFace("beam.r3"),
                            "tail.e2", tabWidth, mirror=True)


if __name__ == "__main__":
  f = SegSheath()
  f._make_test()

