from svggen.api.component import Component
from svggen.api.composables.graph.Face import RegularNGon2 as Shape
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort


class RegularNGon(Component):

  _test_params = {
    'n': 7,
    'radius': 10,
  }

  def define(self):
    self.addParameter("n")
    self.addParameter("radius")
    self.addParameter("label", "graph")

    self.addInterface("e0", EdgePort(self, None))
    self.addInterface("face", FacePort(self, None, None))

  def assemble(self):
    n = self.getParameter("n")
    l = self.getParameter("radius")
    label = self.getParameter("label")

    graph = Graph()
    graph.addFace(Shape("r", n, l))
    self.composables[label] = graph

    for i in range(n):
        try: 
            self.setInterface("e%d" % i, EdgePort(self, "e%d" % i))
        except KeyError:
            self.addInterface("e%d"%i, EdgePort(self, None))
            self.setInterface("e%d" % i, EdgePort(self, "e%d" % i))
    self.setInterface("face", FacePort(self, graph, "r"))

if __name__ == "__main__":
    h = RegularNGon()
    h._make_test()

