from svggen.api.component import Component
from svggen.api.composables.graph.Face import Rectangle as Rect
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort


class Rectangle(Component):

  _test_params = {
    'l': 100,
    'w': 400,
  }

  def define(self):
    self.addParameter("l", paramtype="length")
    self.addParameter("w", paramtype="length")

    self.addInterface("t", EdgePort(self, None))
    self.addInterface("b", EdgePort(self, None))
    self.addInterface("l", EdgePort(self, None))
    self.addInterface("r", EdgePort(self, None))
    self.addInterface("face", FacePort(self, None, None))

  def assemble(self):
    dx = self.getParameter("l")
    dy = self.getParameter("w")

    graph = Graph()
    graph.addFace(Rect("r", dx, dy))
    self.composables["graph"] = graph

    self.setInterface("b", EdgePort(self, "e0"))
    self.setInterface("r", EdgePort(self, "e1"))
    self.setInterface("t", EdgePort(self, "e2"))
    self.setInterface("l", EdgePort(self, "e3"))
    self.setInterface("face", FacePort(self, graph, "r"))

if __name__ == "__main__":
    h = Rectangle()
    h._make_test()

