from math import sqrt

from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort


class PointedLeg(Component):
    _test_params = {
        'length': 150,
        'rightwidth': 40,
        'frontwidth': 20,
    }

    def define(self):
        self.addParameter("beamwidth")
        self.addParameter("rightwidth", 7)
        self.addParameter("frontwidth", 7)
        self.addParameter("length")
        self.addParameter("phase", False)
        self.addParameter("top", 0)

        self.addInterface("front", EdgePort(self, None))
        self.addInterface("right", EdgePort(self, None))
        self.addInterface("slots", EdgePort(self, None))
        self.addInterface("diag", EdgePort(self, None))
        self.addInterface("top", EdgePort(self, None))
        self.addInterface("t0", FacePort(self, None, None))

    def assemble(self):
        try:
          rw = self.getParameter("beamwidth")
          fw = self.getParameter("beamwidth")
        except KeyError:
          rw = self.getParameter("rightwidth")
          fw = self.getParameter("frontwidth")

        l = self.getParameter("length")
        w2 = sqrt(rw * rw + fw * fw)
        w = min(fw, rw)/2.
        l = l-w

        graph = Graph()
        r = Rectangle("", w2, l)
        t = self.getParameter("top")

        graph.attachFace(None, Face("", ((fw, -w), (fw, l), (0, l), (0,0))), None, "r1")
        graph.attachFace("r1.e2", Rectangle("", fw, t), "e0", "t1", angle=0)
        graph.attachFace("r1.e1", Face("", ((rw, w), (rw, l+w), (0, l+w), (0,0))), "e3", "r2", angle=90)
        graph.attachFace("r2.e2", Rectangle("", rw, t), "e0", "t2", angle=0)
        graph.mergeEdge("t1.e1", "t2.e3", angle=90)
        if self.getParameter("phase"):
          graph.attachFace("r2.e1", r, "e3", "r0", angle=135)
          graph.attachFace("r0.e2", Rectangle("", w2, t), "e0", "t0", angle=0)
          graph.mergeEdge("t2.e1", "t0.e3", angle=135)
          graph.addTab("r1.e3", "r0.e1", angle = 135, width=w2)
          self.setInterface("slots", EdgePort(self, "r0.e1"))
          self.setInterface("top", EdgePort(self, "t0.e1"))
        else:
          graph.attachFace("r1.e3", r, "e1", "r0", angle=135)
          graph.attachFace("r0.e2", Rectangle("", w2, t), "e0", "t0", angle=0)
          graph.mergeEdge("t1.e3", "t0.e1", angle=135)
          graph.addTab("r2.e1", "r0.e3", angle = 135, width=w2)
          self.setInterface("slots", EdgePort(self, "r0.e3"))
          self.setInterface("top", EdgePort(self, "t0.e3"))

        #addTabs(graph, "t1", "r2.e1", ("r0", "r0.e3"), width=min(w2, 10), angle=135)
        # self.addConnectors((Tab(), "t1"), "r2.e1", "r0.e3", min(10, w2), angle=135)
        
        self.composables["graph"] = graph

        self.setInterface("t0", FacePort(self, graph, "t0"))
        self.setInterface("front", EdgePort(self, "t1.e2"))
        self.setInterface("right", EdgePort(self, "t2.e2"))
        self.setInterface("diag", EdgePort(self, "t0.e2"))
       

if __name__ == "__main__":
  e = PointedLeg()
  e.setParameter("phase", True)
  e.setParameter("top", 20)
  e._make_test()

