from svggen.api.component import Component
from svggen.api.ports.ModularPort import ModularPort

class MountedGripper(Component):
  def __init__(self):
    # XXX Check for yaml definition by default?
    Component.__init__(self, "MountedGripper.yaml")

  def define(self):
    modular = {}
    modular["edges"] = {"FL": "topedge0",
                        "FR": "topedge2",
                        "BR": "botedge2",
                        "BL": "botedge0",}
    modular["faces"] = {"R": None,
                        "T": None,
                        "L": ["centerface", "rightface", "leftface"],
                        "B": None, }
    modular["parameters"] = { "length": {"parameter": "length"},
                              "depth" : {"parameter": "depth"},
                              "width" : {"parameter": "width"},
                              "minwidth" : {"parameter": "servo", "function": "x.getParameter('motorlength') + x.getParameter('shoulderlength')*2"},
                              "mindepth" : 0,
                              "minlength" : {"parameter": "servo", "function": "2*x.getParameter('motorwidth')"}}

    self.addInterface("modular", ModularPort(self, modular))

  def modifyParameters(self):
    #XXX duplicated from modular
    try:
      self.setParameter("width", max(self.getParameter("width"), self.getParameter("servo").getParameter('motorlength') + self.getParameter("servo").getParameter('shoulderlength')*2))
    except KeyError:
      self.setParameter("width", self.getParameter("servo").getParameter('motorlength') + self.getParameter("servo").getParameter('shoulderlength')*2)

    try:
      self.setParameter("length", max(self.getParameter("length"), 2*self.getParameter("servo").getParameter('motorwidth')))
    except KeyError:
      self.setParameter("length", 2*self.getParameter("servo").getParameter('motorwidth'))

