from svggen.api.ElectricalComponent import ElectricalComponent
from svggen.api.ports.AnalogOutputPort import AnalogOutputPort
from svggen.api.ports.Ground import Ground

__author__ = 'Joseph'

class MicrophoneDevice(ElectricalComponent):
  def define(self):
    ElectricalComponent.define(self)
    self.addInterface('sensorSignal', AnalogOutputPort(parent=self, name='sensorSignal'))
    self.addInterface('ground', Ground(parent=self, name='ground', voltage=0))
    self.addInterface('power', Ground(parent=self, name='power', voltage=(3,5)))

  def assemble(self):
    ElectricalComponent.assemble(self)
    ElectricalComponent.setControllerPins(self)
