from svggen.api.component import Component
from svggen.utils import tabs
from svggen.utils.dimensions import tgy1370a
from svggen.library.Arduino import ArduinoProMini
from svggen.api.Function import Function

from math import sin, cos, pi, sqrt, atan2

def dxy(width, gap, cols, angle):
    dl = width + gap*2
    da = angle * 1. / cols
    dx = 0
    dy = 0
    for i in range(cols):
        dx += dl * cos((i+1) * pi * da / 180.)
        dy += dl * sin((i+1) * pi * da / 180.)
    return dx, dy

def dxyr(width, gap, cols, angle):
    dx, dy = dxy(width, gap, cols, angle)
    hyp2 = sqrt(dx*dx + dy*dy) / 2
    angle = pi/2 - atan2(dy, dx)
    print angle * 180 / pi
    r = hyp2 / cos(angle)
    return dx, dy, r

class LivingHinge(Component):

    _test_params = {
        'length': 30,
        'width': 5,
        'barheight': 10,
        'rows': 3,
        'cols': 9,
        'angle': 180,
        'gap': 2,
        'handle': 100,
    }

    def dxy(self):
        return dxy(self.getParameter("width"), self.getParameter("gap"),
                self.getParameter("cols"), self.getParameter("angle"))

    def define(self):
        self.addSubcomponent("c0000", "HingeCell", 
                inherit="length width barheight gap".split(), prefix=None)
        self.addSubcomponent("leftsplit", "SplitEdge")
        self.addSubcomponent("rightsplit", "SplitEdge")

        self.addParameter("rows")
        self.addParameter("cols")
        self.addParameter("angle")

        self.addParameter("handle", 0)

        self.addConstraint(("leftsplit", "tolerance"), "handle")
        self.addConstraint(("rightsplit", "tolerance"), "handle")

        self.inheritInterface("leftedge", ("leftsplit", "botedge0"))
        self.inheritInterface("rightedge", ("rightsplit", "topedge0"))

    def modifyParameters(self):
        rows = self.getParameter("rows")
        cols = self.getParameter("cols")
      
        splitparams = ("rows", "length", "barheight")

        self.addConstraint(("leftsplit", "botlength"), splitparams, "(x[0] * (x[1]+2*x[2]/2.),)")
        self.addConstraint(("leftsplit", "toplength"), splitparams, "x[0] * (x[2]/2., x[1], x[2]/2.)")

        self.addConstraint(("rightsplit", "toplength"), splitparams, "(x[0] * (x[1]+2*x[2]/2.),)")
        self.addConstraint(("rightsplit", "botlength"), splitparams, "x[0] * (x[2]/2., x[1], x[2]/2.)")

        for r in range(rows):
            for c in range(cols):
                cname = "c%02d%02d" % (r, c)
                if r or c:
                    self.addSubcomponent(cname, "HingeCell", 
                            inherit="length width barheight gap".split(), prefix=None)
                if (r + c) % 2:
                    self.addConstConstraint((cname, "flip"), True)
                if r:
                    self.addConnection((cname, "botedge"), 
                                       ("c%02d%02d" % (r-1, c), "topedge"))
                if c:
                    outedge = ("c%02d%02d" % (r, c-1), "outedge")
                else:
                    outedge = ("leftsplit", "topedge%d" % (3*r + 2 - (r%2)*2))
                self.addConnection((cname, "inedge"), outedge, 
                        angle=Function(("angle", "cols"), "x[0]*1./x[1]"), 
                        edgeType="BEND")
            outedge = ("c%02d%02d" % (r, cols-1), "outedge")
            if cols % 2:
                inedge = ("rightsplit", "botedge%d" % (3*r + (r%2)*2))
            else:
                inedge = ("rightsplit", "botedge%d" % (3*r + 2 - (r%2)*2))
            self.addConnection(inedge, outedge)

if __name__ == "__main__":
  f = LivingHinge()
  f._make_test(thickness=1)
  print f.dxy()

