from svggen.api.component import Component
from svggen.api.ports.EdgePort import EdgePort
from svggen.utils import tabs
from svggen.utils.dimensions import tgy1370a
from svggen.library.Arduino import ArduinoProMini

class LegDrive(Component):
  _test_params = {
    "servo" : tgy1370a,
    "height" : 20,
    "length" : 80,
    "leg.beamwidth" : 5,
    "depth" : tgy1370a.getParameter('motorwidth'),
    "width" : tgy1370a.getParameter('motorheight') + 5,
    "controller": ArduinoProMini(),
  }

  def __init__(self):
    # XXX Check for yaml definition by default?
    Component.__init__(self, "LegDrive.yaml")

  def assemble(self):
    ### XXX hack to get 3 faces along an edge
    graph = self.composables["graph"]

    tabWidth = self.getParameter("width")
    tab = tabs.BeamTabs(self.getParameter("length"), tabWidth, frac=0.25)

    graph.attachFace(self.getInterfaces("motor", "tabedge").getEdges()[0],
                     tab, "tabedge", prefix="movingLegBeam", angle=90)
    tabs.BeamSlotDecoration(graph.getFace("motor.servo.mount.beam.r0"),
                            "move.topsplit.e0", tabWidth, frac=0.25)

    tab = tabs.BeamTabs(self.getParameter("length"), tabWidth, frac=0.25)
    graph.attachFace(self.getInterfaces("move", "botedge").getEdges()[0],
                     tab, "tabedge", prefix="movingLegFlexure", angle=0)

    tabs.BeamSlotDecoration(graph.getFace("motor.servo.mount.beam.r2"),
                            "motor.servo.mount.beam.r3.e3", tabWidth, frac=0.25)

    self.setInterface("slotedge", EdgePort(self, "movingLegFlexure.slotedge"))

if __name__ == "__main__":
  f = LegDrive()
  f._make_test()
