from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort
from svggen.utils.mymath import sin, cos, tan, deg2rad


class Kite(Component):

  _test_params = {
    'angle': 45,
    'thickness': 10,
  }

  def define(self):
    self.addParameter("thickness", paramtype="length")
    self.addParameter("angle", paramtype="angle")

    self.addInterface("b", EdgePort(self, None))
    self.addInterface("t", EdgePort(self, None))

  def assemble(self):
    t = self.getParameter("thickness")
    a = self.getParameter("angle")
    a2 = deg2rad(a/2.)
    ar = deg2rad(a)

    s = Face("", ((t, 0), (t, t * tan(a2)), (t * cos(ar), t * sin(ar)), (0,0)))

    graph = Graph()
    graph.addFace(s, "kite")

    self.composables["graph"] = graph

    self.setInterface("b", EdgePort(self, "kite.e0"))
    self.setInterface("t", EdgePort(self, "kite.e3"))


if __name__ == "__main__":
    h = Kite()
    h._make_test()

