from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class HingeCell(Component):

    _test_params = {
        'length': 20,
        'width': 5,
        'barheight': 10,
        'flip': False,
        'gap': 4,
    }

    def define(self):
        self.addParameter("length")
        self.addParameter("width")
        self.addParameter("barheight")
        self.addParameter("flip", False)
        self.addParameter("gap", 0)

        self.addInterface("topedge", EdgePort(self, None))
        self.addInterface("botedge", EdgePort(self, None))
        self.addInterface("inedge", EdgePort(self, None))
        self.addInterface("outedge", EdgePort(self, None))

    def assemble(self):
        l = self.getParameter("length")
        w = self.getParameter("width")
        b = self.getParameter("barheight") / 2.
        g = self.getParameter("gap") / 2.
        lb = 2*b+l

        if self.getParameter("flip"):
            s = Face("", ((w+g, 0), (w+g, b+l), (w+2*g, b+l), (w+2*g, lb), (g, lb), (g, b), (0, b), (0, 0)))
        else:
            s = Face("", ((w+2*g, 0), (w+2*g, b), (w+g, b), (w+g, lb), (0, lb), (0, lb-b), (g, lb-b), (g, 0)))

        graph = Graph()
        graph.addFace(s, "cell")

        self.composables["graph"] = graph

        self.setInterface("topedge", EdgePort(self, "cell.e4"))
        self.setInterface("botedge", EdgePort(self, "cell.e0"))
        if self.getParameter("flip"):
            self.setInterface("inedge", EdgePort(self, "cell.e7"))
            self.setInterface("outedge", EdgePort(self, "cell.e3"))
        else:
            self.setInterface("inedge", EdgePort(self, "cell.e5"))
            self.setInterface("outedge", EdgePort(self, "cell.e1"))

if __name__ == "__main__":
    h = HingeCell()
    h._make_test()

