from svggen.api.component import Component
from svggen.api.composables.GraphComposable import Decoration
from svggen.api.composables.graph.Face import Face
from svggen.api.ports.MountPort import MountPort


class Header(Component):

  def define(self):
      self.addParameter("nrows", 0)
      self.addParameter("ncols", 0)
      self.addParameter("rowsep", 2.54)
      self.addParameter("colsep", 2.54)
      self.addParameter("diameter", 1)
      self.addInterface("mount", MountPort(self, None))

  def assemble(self):
    diam = self.getParameter("diameter")/2.
    nr = self.getParameter("nrows")
    nc = self.getParameter("ncols")

    def hole(i, j, d):
      dx = (j - (nc-1)/2.)*self.getParameter("colsep")
      dy = (i - (nr-1)/2.)*self.getParameter("rowsep")
      return Face("r-%d-%d" % (i,j),
                        ((dx-d, dy-d), (dx+d, dy-d), (dx+d, dy+d), (dx-d, dy+d)),
                        recenter=False)

    graph = Decoration()
    for i in range(nr):
      for j in range(nc):
        d = diam
        if (i == 0 and j == 0) or \
           (i == nr-1 and j == nc-1):
               d = diam*3
        graph.addFace(hole(i,j,d), prefix="r-%d-%d" % (i,j))
    self.setInterface("mount", MountPort(self, graph))

if __name__ == "__main__":
    h = Header()
    h.setParameter("nrows", 11)
    h.setParameter("ncols", 2)
    h.setParameter("rowsep", 0.1 * 25.4)
    h.setParameter("colsep", 0.6 * 25.4)
    h.make()
