from svggen.utils.mymath import sqrt

from svggen.api.component import Component
from svggen.api.Function import Function


class FourBarDoubleLeg(Component):
  _test_params = {
    "flexlengthx" : 20, 
    "flexwidth" : 5, 
    "depth" : 9, 
    "phase" : True, 
    "height" : 10, 
    "length" : 40, 
    "dl" : 10, 
    "leg.beamwidth" : 5, 
  }

  def define(self):
    self.addSubcomponent("fakelegmount", "Rectangle")
    self.addSubcomponent("s1", "Rectangle")
    self.addSubcomponent("s2", "Rectangle")
    self.addSubcomponent("fakeleg", "Rectangle")
    self.addSubcomponent("spacer", "Rectangle")

    self.addSubcomponent("linkage", "FourBar", inherit=("depth", "flexwidth", "flexlengthx", "ratio"), prefix=None)
    self.addSubcomponent("leg", "FlatLeg", inherit=("phase",), prefix=None)
    self.addSubcomponent("hole1", "Cutout")
    self.addSubcomponent("hole2", "Cutout")
    self.addSubcomponent("holec", "Cutout")

    self.addParameter("length")
    self.addParameter("height")
    self.addParameter("dl", 0)

    self.addParameter("leg.beamwidth", 7)

    ### Set specific relationships between parameters
    self.addConstraint(("leg", "length"), "height")
    self.addConstraint(("leg", "beamwidth"), "leg.beamwidth")
    self.addConstraint(("leg", "top"), "depth")

    self.addConstraint(("linkage", "flexlengthy"),
                       ("length", "leg.beamwidth", "dl"), " (x[0] - %f * x[1]) / 2. - x[2]" % (3*sqrt(2)))

    self.addConstConstraint(("hole1", "d"), 1.5)
    self.addConstConstraint(("hole2", "d"), 1.5)
    self.addConstConstraint(("holec", "d"), 1.5)

    self.addConstraint(("s1", "l"), "depth")
    self.addConstraint(("s1", "w"), "leg.beamwidth", " %f * x" % sqrt(2))

    self.addConstraint(("s2", "l"), "depth")
    self.addConstraint(("s2", "w"), "leg.beamwidth", " %f * x" % sqrt(2))

    self.addConstraint(("fakelegmount", "l"), "depth")
    self.addConstraint(("fakelegmount", "w"), "leg.beamwidth", " %f * x" % sqrt(2))

    self.addConstraint(("spacer", "l"), "depth")
    self.addConstraint(("spacer", "w"),
                       ("leg.beamwidth", "dl"), "2 * x[1] - %f * x[0]" % sqrt(2))

    self.addConstraint(("fakeleg", "l"), "height")
    self.addConstraint(("fakeleg", "w"), "leg.beamwidth", " %f * x" % sqrt(2))

    self.addConnection(("spacer", "face"),
                       ("holec", "hole"))

    self.addConnection(("linkage", "output"),
                       ("fakelegmount", "t"),
                       angle=0)
    '''
    self.addConnection(("fakelegmount", "l"),
                       ("fakeleg", "r"),
                       angle=0)
    '''
    self.addConnection(("fakelegmount", "b"),
                       ("s1", "t"),
                       angle=0)
    self.addConnection(("s1", "b"),
                       ("spacer", "t"),
                       angle=0)
    self.addConnection(("spacer", "b"),
                       ("s2", "t"),
                       angle=0)
    self.addConnection(("s2", "b"),
                       ("leg", "top"),
                       angle=0)

    self.addConnection(("s1", "face"),
                       ("hole1", "hole"))
    self.addConnection(("s2", "face"),
                       ("hole2", "hole"))

    self.inheritInterface("topedge", ("linkage", "topedge"))
    self.inheritInterface("botedge", ("linkage", "botedge"))

  def assemble(self):
    ### Assemble the object

    if self.getParameter("phase"):
      spacerEdge = "r"
      slotEdge = "t"
      first = 1
    else:
      spacerEdge = "l"
      slotEdge = "b"
      first = 2

    bw = self.getParameter("leg.beamwidth")

    self.attach(("fakelegmount", spacerEdge),
                ("fakeleg", "r"), {"angle":0})

    # XXX not really, but it puts the extra slots in the right place
    self.attach(("fakeleg", slotEdge),
                ("leg", "slots"),
                {"angle": 0, "tabWidth": bw * sqrt(2)})

if __name__ == "__main__":
  f = FourBarDoubleLeg()
  f._make_test()
