from svggen.api.component import Component
from svggen.api.composables.graph.Face import Rectangle, Face
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class ForkTines(Component):

    _test_params = {
        'width': 100,
        'forkwidth': 13,
        'forkdepth': 44,
        'forkheight': 21,
        'forkinset': 27,
    }

    def define(self):
        self.addParameter("width")
        self.addParameter("forkdepth")
        self.addParameter("forkheight")
        self.addParameter("forkinset")
        self.addParameter("forkwidth", 5)

        self.addInterface("topedge", EdgePort(self, None))
        self.addInterface("botedge", EdgePort(self, None))

    def assemble(self):
        width = self.getParameter("width")
        d = self.getParameter("forkdepth")
        h = self.getParameter("forkheight")
        i = self.getParameter("forkinset")
        w = self.getParameter("forkwidth", 5)

        graph = Graph()

        r = Face('', ((width, 0), (width, w), (w, w), (0,0)))
        graph.addFace(r, 'r0')

        r = Face('', ((w, w), (w, width), (0, width), (0,0)))
        graph.attachFace('r0.e3', r, 'e0', 'r1', angle=180)

        r = Rectangle('', w, h)
        graph.attachFace('r1.e2', r, 'e0', 'r2', angle=-90)

        r = Rectangle('', w, d)
        graph.attachFace('r2.e2', r, 'e0', 'r3', angle=90)

        r = Rectangle('', w, d+i)
        graph.attachFace('r3.e2', r, 'e0', 'r4', angle=-180)

        r = Rectangle('', w, h)
        graph.attachFace('r4.e2', r, 'e0', 'r5', angle=-90)

        r = Face('', ((width-i, 0), (width-i, w), (w, w), (0,0)))
        graph.attachFace('r5.e2', r, 'e1', 'r6', angle=90)

        r = Face('', ((w,w), (w, width-i), (0, width-i), (0,0)))
        graph.attachFace('r6.e3', r, 'e0', 'r7', angle=180)

        r = Face('', ((w,0), (w, width-i), (0, width-i), (0,0)))
        graph.attachFace('r7.e3', r, 'e1', 'r8', angle=-180)

        r = Face('', ((width-i, 0), (width, 0), (0,0)))
        graph.attachFace('r8.e3', r, 'e0', 'r9', angle=0)

        self.composables["graph"] = graph

        self.setInterface("topedge", EdgePort(self, "r0.e0"))
        self.setInterface("botedge", EdgePort(self, "r9.e2"))

if __name__ == "__main__":
  e = ForkTines()
  e._make_test()

