from svggen.api.component import Component
from svggen.utils import tabs
from svggen.utils.dimensions import tgy1370a
from svggen.library.Arduino import ArduinoProMini
from svggen.library.Arduino import ESP8266
from svggen.api.Function import Function



class ESPSegSheath(Component):

  _test_params = {
    'controller': ESP8266(),
    'length': 43,
    'width': 59.5,
    'depth': 12,
    'height': 60
  }

  def define(self):
    self.addSubcomponent("beam", "RectBeam", inherit=True, prefix=None)
    self.addSubcomponent("tail", "Rectangle")
    self.addSubcomponent("header", "Header")
    self.addSubcomponent("rwire", "Cutout")
    self.addSubcomponent("lwire", "Cutout")
    self.addSubcomponent("servoPins", "Cutout")

    self.addParameter("height")
    self.addParameter("controller")

    def getBrainParameter(p):
      return "controller", "x.getDimension('%s')" % p

    self.addConstraint(("header", "nrows"), *getBrainParameter("nrows"))
    self.addConstraint(("header", "ncols"), *getBrainParameter("ncols"))
    self.addConstraint(("header", "rowsep"), *getBrainParameter("rowsep"))
    self.addConstraint(("header", "colsep"), *getBrainParameter("colsep"))

    self.addConstConstraint(("beam", "faces"), range(4))

    self.addConstConstraint(("rwire", "dx"), 10)
    self.addConstConstraint(("rwire", "dy"), 4)
    self.addConstConstraint(("lwire", "dx"), 10)
    self.addConstConstraint(("lwire", "dy"), 4)
    
    self.addConstConstraint(("servoPins", "dx"), 8)
    self.addConstConstraint(("servoPins", "dy"), 27)

    self.addConstraint(("tail", "l"), "length")
    self.addConstraint(("tail", "w"), ("height", "depth"), "x[0] - x[1]/2.")

    self.inheritAllInterfaces("beam", prefix=None)

    self.addConnection(("beam", "tabedge"),
                       ("tail", "t"),
                       angle=0)

    self.addConnection(("beam", "face2"),
                       ("header", "mount"),
                       mode="hole", rotate=True, offset=Function(params=("width", "controller"), fnstring="((0.5 * (x[0]-x[1].getDimension('length')))-4.5, -7.5)"))
                       #mode="hole", rotate=True, offset=Function(params=("width", "controller"), fnstring="(-0.5 * (x[0]-x[1].getDimension('length')), 0)"))

    self.addConnection(("beam", "face2"),
                       ("servoPins", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("width", "controller"), fnstring="((0.5 * (x[0]-x[1].getDimension('length')))-14, +17.25)"))

    self.addConnection(("beam", "face1"),
                       ("rwire", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("depth", "controller"), fnstring="(x[0]/2. - 3, -0.5*x[1].getDimension('width')-6)"))

    self.addConnection(("beam", "face1"),
                       ("lwire", "hole"),
                       mode="hole", rotate=True, offset=Function(params=("depth", "controller"), fnstring="(x[0]/2. - 3, 0.5*x[1].getDimension('width')+6)"))

  def assemble(self):
    ### Assemble the object

    ### XXX hack to get 3 faces along an edge
    graph = self.composables["graph"]

    tabWidth = self.getParameter("depth")
    tab = tabs.BeamTabs(self.getParameter("length"), tabWidth, mirror=True)

    graph.attachFace(self.getInterfaces("beam", "slotedge").getEdges()[0],
                     tab, "tabedge", prefix="beamtab", angle=90)
    tabs.BeamSlotDecoration(graph.getFace("beam.r3"),
                            "tail.e2", tabWidth, mirror=True)


if __name__ == "__main__":
  f = ESPSegSheath()
  f._make_test()

