from svggen.api.component import Component
from svggen.utils.dimensions import fs90r
from svggen.library.Arduino import ESP8266
from svggen.utils.utils import copyDecorations

class ESPCore(Component):

  _test_params = {
    "driveservo" : fs90r,
    "controller": ESP8266(),
    "height" : 50,
    "length" : 90,
    "width"  : 65,
    "battery": 7,
  }

  def __init__(self):
    # XXX Check for yaml definition by default?
    Component.__init__(self, "ESPCore.yaml")

  def assemble(self):
    copyDecorations(self, ("rightservoface", ("right", "face2", 1, 2)),
                          ("rightservosheath", ("sheath", "face3", -1, 0)))
    copyDecorations(self, ("leftservoface", ("left", "face2", 2, 1)),
                          ("leftservosheath", ("sheath", "face1", 0, -1)))
    copyDecorations(self, ("brainface", ("brain", "face1", 0, 1)),
                          ("brainsheath", ("sheath", "face2", 1, 2)))

if __name__ == "__main__":
  f = ESPCore()
  f._make_test()

