from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class Dovetail(Component):

    _test_params = {
        'length': 200,
        'width': 50,
        'pitch': 20,
    }

    def define(self):
        self.addParameter("length")
        self.addParameter("width")
        self.addParameter("pitch")
        self.addParameter("dx", 0.5)
        self.addParameter("dy", 0.25)

        self.addInterface("topedge", EdgePort(self, None))
        self.addInterface("botedge", EdgePort(self, None))
        self.addInterface("rtedge", EdgePort(self, None))

    def assemble(self):
        l = self.getParameter("length")
        w = self.getParameter("width")
        p = self.getParameter("pitch")
        dx = self.getParameter("dx")
        dy = self.getParameter("dy")

        dx = -p*dx
        dp = p*dy
        pts = [(w, 0), (w, l), (0, l), (dx, l)]
        y = l-p/2.

        while (y > dp):
            pts += [(dx, y-dp), (-dx, y+dp)]
            dx = -dx
            y -= p
        pts += [(dx, 0), (0,0)]
          
        s = Face("", pts)

        graph = Graph()
        graph.addFace(s, "face")

        self.composables["graph"] = graph

        self.setInterface("botedge", EdgePort(self, "face.e0"))
        self.setInterface("rtedge", EdgePort(self, "face.e1"))
        self.setInterface("topedge", EdgePort(self, "face.e2"))

if __name__ == "__main__":
    h = Dovetail()
    h._make_test()

