from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face
from svggen.api.composables.GraphComposable import Decoration
from svggen.api.ports.MountPort import MountPort

class DistanceSensorMount(Component):

  _test_params = {
    'w': 20,
  }

  def define(self):
      self.addParameter("w", 13)
      self.addInterface("mount", MountPort(self, None))

  def assemble(self):
    w = self.getParameter("w")/2.
    dx = -29.4/2
    dy = -8.4/2
    t = -11./2
    d = -4.4 - w

    graph = Decoration()
    graph.addFace(Face('', ((-dx, -dy), (dx, -dy), (dx, dy), (t, dy), (t, d), (-t, d), (-t, dy), (-dx, dy)), recenter=False), "hole")
    self.setInterface("mount", MountPort(self, graph))

if __name__ == "__main__":
    h = DistanceSensorMount()
    h._make_test()

