from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle
from svggen.api.composables.GraphComposable import Graph, Decoration
from svggen.api.ports.FacePort import FacePort
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.ModularPort import ModularPort
import svggen.utils.mymath as math

class DeltaMotor(Component):

  _test_params = {
    'bodylength': 100,
    'motorwidth': 50,
  }


  def define(self):
    self.addParameter("bodylength")
    self.addParameter("motorwidth")

    self.addInterface("l", EdgePort(self, None))
    self.addInterface("r", EdgePort(self, None))

  def assemble(self):
    graph = Graph()
    deco = Decoration()

    bodylength = self.getParameter("bodylength")
    motorwidth = self.getParameter("motorwidth")

    angle = motorwidth * 1.0 / bodylength / 2
    x = bodylength*math.cos(angle)
    y = bodylength*math.sin(angle)

    graph.addFace(Face("", (
        (x, -y), (x, y), (0, 0)
    )), "mount")

    dt = 0.1
    dx = 5

    for i in range(dx, x, dx):
        deco.addFace(

    self.composables["graph"] = graph

    self.setInterface("r", EdgePort(self, "mount.e0"))
    self.setInterface("l", EdgePort(self, "mount.e2"))

if __name__ == "__main__":
  b = DeltaMotor()
  b._make_test()

