from svggen.api.component import Component
from svggen.api.composables.graph.Face import Rectangle
from svggen.api.composables.GraphComposable import Decoration
from svggen.api.ports.MountPort import MountPort

class Cutout(Component):

  _test_params = {
    'd': 10,
  }

  def define(self):
      self.addParameter("dx")
      self.addParameter("dy")
      self.addParameter("d")
      self.addInterface("hole", MountPort(self, None))

  def assemble(self):
    try:
      dx = self.getParameter("d")
      dy = self.getParameter("d")
    except KeyError:
      dx = self.getParameter("dx")
      dy = self.getParameter("dy")

    graph = Decoration()
    graph.addFace(Rectangle("r0", dx, dy), prefix="r0")
    self.setInterface("hole", MountPort(self, graph))

if __name__ == "__main__":
    h = Cutout()
    h._make_test()

