from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle, RegularNGon as Shape
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class Corner(Component):

    _test_params = {
        'length': 30,
        'width': 40,
        'height': 50,
    }

    def define(self):
        self.addParameter("length")
        self.addParameter("width")
        self.addParameter("height")

    def assemble(self):
        l = self.getParameter("length")
        w = self.getParameter("width")
        h = self.getParameter("height")

        graph = Graph()
        t = Rectangle("", l, w)
        r = Rectangle("", w, h)
        f = Rectangle("", l, h)

        graph.addFace(t, "top")
        graph.attachFace("top.e1", r, "e0", "right", angle=90, )
        graph.attachFace("top.e0", f, "e0", "front", angle=90, )
        graph.mergeEdge("right.e1", "front.e3", angle=90, )

        self.composables["graph"] = graph

if __name__ == "__main__":
    from svggen.api.composables.graph.Joint import FingerJoint
    h = Corner()
    h._make_test(thickness=4, joint=FingerJoint(thickness=4))

