from svggen.api.ElectricalComponent import ElectricalComponent
from svggen.api.ports.PowerInputPort import PowerInputPort
from svggen.api.ports.OneWireSerialPort import OneWireSerialPort
from svggen.api.ports.Ground import Ground

__author__ = 'Joseph'

# Device representing the ColorPAL (#28380)
class ColorSensorDevice(ElectricalComponent):
  def define(self):
    ElectricalComponent.define(self)
    self.addInterface('power', PowerInputPort(parent=self, name='power', voltage=5))
    self.addInterface('signal', OneWireSerialPort(parent=self, name='signal', voltage=5))
    self.addInterface('ground', Ground(parent=self, name='ground', voltage=0))


  def assemble(self):
    ElectricalComponent.assemble(self)
    ElectricalComponent.setControllerPins(self)
