from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
from svggen.api.ports.FacePort import FacePort


class CaseHalf(Component):

  _test_params = {
    'l': 100,
    'w': 400,
    'l1': 50,
    'w1': 75,
  }

  def define(self):
    self.addParameter("l", 38)
    self.addParameter("w")
    self.addParameter("l1")
    self.addParameter("w1")

    self.addInterface("t", EdgePort(self, None))
    self.addInterface("b", EdgePort(self, None))
    self.addInterface("face", FacePort(self, None, None))

  def assemble(self):
    x = self.getParameter("l")
    y = self.getParameter("w")
    x1 = self.getParameter("l1")
    y1 = self.getParameter("w1")

    graph = Graph()
    graph.addFace(Face("r", ((0,y1), (x1,y1), (x1,0), (x,0), (x,y), (0,y), (0,0))))
    self.composables["graph"] = graph

    self.setInterface("b", EdgePort(self, "e4"))
    self.setInterface("t", EdgePort(self, "e6"))
    self.setInterface("face", FacePort(self, graph, "r"))

if __name__ == "__main__":
    h = CaseHalf()
    h._make_test()

