from svggen.api.component import Component
from svggen.utils import tabs


class Bumper(Component):

  _test_params = {
    'height': 30,
    'length': 50,
    'depth': 12.2,
    'width': 10,
  }

  def define(self):
    self.addSubcomponent("beam", "RectBeam", inherit=True, prefix=None)
    self.addSubcomponent("tail", "Rectangle")

    self.addParameter("height")

    self.addConstConstraint(("beam", "faces"), range(4))
    self.addConstraint(("beam", "depth"), "depth")
    self.addConstraint(("beam", "width"), "width")

    self.addConstraint(("tail", "l"), "length")
    self.addConstraint(("tail", "w"), "height")

    self.inheritAllInterfaces("beam", prefix=None)

    self.addConnection(("beam", "slotedge"),
                       ("tail", "t"),
                       angle=0)

  def assemble(self):
    ### XXX hack to get 3 faces along an edge
    graph = self.composables["graph"]

    tabWidth = self.getParameter("width")
    tab = tabs.BeamTabs(self.getParameter("length"), tabWidth)

    graph.attachFace(self.getInterfaces("beam", "tabedge").getEdges()[0],
                     tab, "tabedge", prefix="beamtab", angle=90)
    tabs.BeamSlotDecoration(graph.getFace("beam.r0"),
                                "tail.e2", tabWidth)


if __name__ == "__main__":
  f = Bumper()
  f._make_test()

