from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle, RegularNGon as Shape
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort


class Box(Component):

    _test_params = {
        'height': 50,
        'edge': 100,
        'sides': 6,
    }

    def define(self):
        self.addParameter("height")
        self.addParameter("edge")
        self.addParameter("sides")

    def assemble(self):
        h = self.getParameter("height")
        e = self.getParameter("edge")
        n = self.getParameter("sides")

        graph = Graph()
        graph.addFace(Shape("", n, e), "bottom")

        for i in range(n):
            s = Rectangle("", e, h)
            graph.attachFace("bottom.e%d" % i, s, "e0", "side%d" % i, angle=90)

        self.composables["graph"] = graph

if __name__ == "__main__":
    from svggen.api.composables.graph.Joint import FingerJoint
    h = Box()
    h._make_test(thickness=4, joint=FingerJoint(thickness=6))

