from svggen.api.component import Component
from svggen.api.composables.graph.Face import Face, Rectangle, RightTriangle
from svggen.api.composables.GraphComposable import Graph
from svggen.api.ports.EdgePort import EdgePort
import svggen.utils.mymath as math


class BoatBase(Component):
    _test_params = { }

    def define(self):
        self.addParameter("length", 250)
        self.addParameter("width", 50)
        self.addParameter("depth", 20)
        self.addParameter("bow", 45)
        self.addParameter("stern", 0)

        self.addInterface("staredge", EdgePort(self, None))
        self.addInterface("portedge", EdgePort(self, None))

    def assemble(self):
        l = self.getParameter("length")
        w = self.getParameter("width")
        h = self.getParameter("depth")
        b = self.getParameter("bow")
        s = self.getParameter("stern")

        graph = Graph()
        bottom = Rectangle("", l, w)
        graph.addFace(bottom, "bt")

        lt = Rectangle("", l, h)
        graph.attachFace("bt.e0", lt, "e2", prefix="lt", angle=90)
        rt = Rectangle("", l, h)
        graph.attachFace("bt.e2", rt, "e0", prefix="rt", angle=90)

        def point(lbl, d, edge, flip=False):
            lb = math.sqrt(h*h+d*d)
            ab = math.rad2deg(math.arctan2(h,d))
            f = Face("", ((w/2.,0), (0, lb), (-w/2., 0)))
            graph.attachFace("bt."+edge, f, "e0", prefix=lbl, angle=ab)

            lb = math.sqrt(w*w/4.+d*d)
            ab = math.rad2deg(math.arctan2(w/2.,d))

            f1 = RightTriangle("", h, lb); e1 = "e0"
            #f1a = Face("", ((h, 0), (0, lb), (0,0*lb/2.)))
            #f1b = Face("", ((lb, 0), (0, h), (0*lb/2.,0)))
            f2 = RightTriangle("", lb, h); e2 = "e2"
            #f2a = Face("", ((lb, 0), (0, h), (0*lb/2.,0)))
            #f2b = Face("", ((h, 0), (0, lb), (0,0*lb/2.)))
            if flip:
                f1, f2 = f2, f1
                #f1a, f2a = f2a, f1a
                #f1b, f2b = f2b, f1b
                e1, e2 = e2, e1

            #graph.attachFace(lbl+".e2", f1, "e1", prefix=lbl+"rt", angle=ab)
            graph.attachFace("rt."+edge, f1, e1, prefix=lbl+"rt", angle=ab)
            #graph.attachFace(lbl+"rt.e1", f1a, "e1", prefix=lbl+"rta", angle=180)
            #graph.attachFace(lbl+"rta."+e2, f1b, e1, prefix=lbl+"rtb", angle=-180)

            #graph.attachFace(lbl+".e1", f2, "e1", prefix=lbl+"lt", angle=ab)
            graph.attachFace("lt."+edge, f2, e2, prefix=lbl+"lt", angle=ab)
            #graph.attachFace(lbl+"lt.e1", f2a, "e1", prefix=lbl+"lta", angle=180)
            #graph.attachFace(lbl+"lta."+e1, f2b, e2, prefix=lbl+"ltb", angle=-180)

        point("bow", b, "e1")
        point("stern", s, "e3", flip=True)

        self.composables["graph"] = graph

        self.setInterface("staredge", EdgePort(self, "rt.e2"))
        self.setInterface("portedge", EdgePort(self, "lt.e0"))


if __name__ == "__main__":
    h = BoatBase()
    h._make_test()

