from svggen.api.Driver import Driver


class BluetoothModuleDriver(Driver):
  def define(self):
    Driver.define(self)

  def assemble(self):
    Driver.assemble(self)

    self.addCodeFile('code/bluetooth_module.cpp')
    self.addCode(self._getSendUIDescriptionCode())

  def _getSendUIDescriptionCode(self):
    code = ''
    code += '@@declare'
    code += '\nPROGMEM const char uiDataMap[] = @uiDataMap;'
    code += """
        @iterate<@uiDescriptions><@
        PROGMEM const char uiDescription_@iterIndex[] = @iterItem;
        @>
        PROGMEM const char* const uiDescriptions[] =
        {
          @iterate<@uiDescriptions><@
          uiDescription_@iterIndex,
          @>
        };
        """
    code += """
        #define sendUIDescription()                                       \\
        char buffer[150];                                                  \\
        for (int i = 0; i < @numUIDescriptions; i++)                      \\
        {                                                                 \\
          strcpy_P(buffer, (char*)pgm_read_word(&(uiDescriptions[i])));   \\
          sendBluetoothData(buffer);                                      \\
        }                                                                 \\
        strcpy_P(buffer, (char*)uiDataMap);                               \\
        sendBluetoothData(buffer);
      """
    return code
