from Menu import Menu
from svggen.api.component import Component
from svggen.library.StateMachine import StateMachine
from svggen.library import filterComponents
from svggen.library import getComponent
from string import ascii_lowercase as letters
from svggen.library.Arduino import ArduinoProMini
from svggen.utils.dimensions import tgy1370a, fs90r
import traceback

def getGrounding(port, allComponents, tag=None, getDataFunction=False):
  if tag:
    components = dict(filterComponents([tag], allComponents))
  else:
    components = dict(allComponents)
  components['Do not ground this proposition'] = ''
  options = [(letters[x[0]], x[1]) for x in enumerate(components.keys())]
  menu = {
    "title": "Select a component",
    "options": options
  }

  m = Menu(menu).go()
  componentName = dict(menu['options'])[m]
  if componentName not in allComponents:
    return
  possibilities = allComponents[componentName]

  if len(possibilities) == 1:
    portName = possibilities[0]
  elif len(possibilities) > 1:
    options = [(letters[x[0]], x[1]) for x in enumerate(possibilities)]
    portmenu = {
      "title": "Select a port on component " + componentName,
      "options": options
    }
    portName = Menu(portmenu).go()
    portName = dict(portmenu['options'])[portName]
  else:
    print "INVALID"
    return
  print

  # Allow user to add a function for converting the state machine's binary output
  dataFunction = ''
  if getDataFunction:
    try:
      # TODO check data type of port first (but currently not all components set their types correctly)
      #port = getComponent(componentName).getInterface(portName)
      #dataType = port.getParameter('dataType')
      #if dataType != bool:
      dataFunction = raw_input('Enter function for converting the binary state output (optional)\n\tUse \"input\" to indicate the binary value in your function\n\tEnter nothing to skip this step\n\tinput >')
      dataFunction = dataFunction.replace('\"input\"', 'input')
    except KeyError:
      pass
  return componentName, portName, dataFunction

class Grounder:
  def __init__(self, machinename=None):
    # Set .smv file
    self.machinename = machinename or raw_input("Enter the name of the ltlmop specification: ")

    # Get list of input and output propositions from .smv
    self.inputs = StateMachine.getInputs(self.machinename)
    self.outputs = StateMachine.getOutputs(self.machinename)

    # Get filtered lists of components
    print "Loading component definitions...", 
    self.sensors = dict(filterComponents(["sensor"]))
    self.actuators = dict(filterComponents(["actuator"]))
    print "done."

    self.constrainedParams = [] # Parameters that the user wants to be the same for every added component

  def ground(self, prop, components, tag=None, getDataFunction=False):
    print "~~~"
    print "Grounding state machine proposition:", prop,
    try:
      component, port, dataFunction = getGrounding(prop, components, tag, getDataFunction)
    except TypeError:
      print "Skipping grounding of proposition", prop
      return

    print "Grounding proposition", prop, "to component", component, "on port", port
    if not getDataFunction:
      self.c.addSubcomponent(prop, component)
      self.c.addConnection(("state", prop), (prop, port))
    else:
      # Add the new component
      self.c.addSubcomponent(prop, component)
      # If a conversion function was supplied, insert data function block
      # Otherwise make a direct connection
      if len(dataFunction) > 0:
        dataFunctionName = prop + '_Function'
        self.c.addSubcomponent(dataFunctionName, 'DataFunction')
        self.c.addConstConstraint((dataFunctionName, 'function'), dataFunction)
        self.c.addConnection(('state', prop), (dataFunctionName, 'input'))
        self.c.addConnection((dataFunctionName, 'output'), (prop, port))
      else:
        self.c.addConnection(("state", prop), (prop, port))

    # Allow user to set parameters of the block
    for paramName in getComponent(component).parameters.keys():
      self._parameterPrompt(prop, paramName)

  def go(self):
    self.c = Component()
    self.c.addSubcomponent("state", "StateMachine")
    self.c.addConstConstraint(("state", "stateMachineName"), self.machinename)

    for prop in self.inputs:
      self.ground(prop, self.sensors, "device")

    for prop in self.outputs:
      self.ground(prop, self.actuators, getDataFunction=True)

  def _parameterPrompt(self, subcomponentName, paramName, evalVal=False):
    # If user already supplied a value for this param name and told us to use it for all components, do so
    if paramName in self.constrainedParams:
      self.c.addConstraint((subcomponentName, paramName), paramName)
    # Otherwise prompt for a new value
    else:
      newValue = raw_input('Value for parameter <' + paramName + '> for component <' + subcomponentName + '> (blank to leave default/unset): ').strip()
      if len(newValue) == 0:
        return False
      # If we should try evaluating the given value, do so now
      if evalVal:
        try:
          newValue = eval(newValue)
        except:
          pass
      # Otherwise see if it is an int or float
      else:
        try:
          newValue = int(newValue)
        except:
          try:
            newValue = float(newValue)
          except:
            pass
      # See if we should use this value again on future components
      allSame = raw_input('\tConstrain all future components\' parameters with this name to this value? y/n: ').lower() == 'y'
      if allSame:
        # Add a parameter at the top level if it doesn't already exist
        try:
          self.c.addParameter(paramName)
        except:
          pass
        # Record that we should use this value automatically later
        self.constrainedParams.append(paramName)
        # Constrain the subcomponent's parameter to the top level parameter
        self.c.addConstraint((subcomponentName, paramName), paramName)
        self.c.setParameter(paramName, newValue)
      else:
        # Only using the value for this component, so just use a constant constraint
        self.c.addConstConstraint((subcomponentName, paramName), newValue)
    return True

  def save(self, filename):
    print ""
    print "New component written to", filename
    print ""
    self.c.toYaml(filename)

  def makeOutput(self, filedir):
    tryAgain = True
    while tryAgain:
      tryAgain = False
      try:
        self.c.makeOutput(filedir)
      except KeyError as error:
        e = str(error)
        # If the error was due to a parameter not being set, allow the user to set it
        if 'not yet set' in e:
          paramName = e[e.lower().find('parameter') + len('parameter') : e.find('not yet set')].strip()
          print '*** Parameter ' + paramName + ' needs to be set to continue ***'
          # We don't know which component prompted this error, so just prompt for all parameters with the given name
          for (componentName, component) in self.c.components.iteritems():
            if paramName in component[0].parameters.keys():
              # If the user sets a value for the parameter, try making the design again
              if self._parameterPrompt(componentName, paramName, evalVal=True):
                tryAgain = True
        else:
          # The error was not from an unset parameter, so raise it again
          print traceback.format_exc()
          raise error


if __name__ == "__main__":
  b = Grounder()
  b.go()
  b.save("test.yaml")
  b.makeOutput('groundedOutput')
