from svggen.api.component import Component
from svggen.api.Function import Function

c = Component()

c.addParameter("height")
c.addParameter("label")

c.addSubcomponent("motor", "Servo", inherit=("controller", "length", "depth", "shift", "width", "servo", "center", "flip", "controllerPin"), prefix=None)
c.addConstConstraint(("motor", 'motionType'), 'continuous')
c.addConstConstraint(("motor", 'min'), 0)
c.addConstConstraint(("motor", 'default'), 50)
c.addConstConstraint(("motor", 'max'), 100)
c.addConstraint(("motor", 'label'), "label", "x + ' drive motor'")

c.addSubcomponent("wheel", "RegularNGon")
c.addConstConstraint(("wheel", 'n'), 40)
c.addConstraint(("wheel", 'label'), "label")
c.addConstraint(("wheel", 'radius'), "height") # +/- depth/2 ?

c.addSubcomponent("centerhole", "Cutout")
c.addConstConstraint(("centerhole", 'd'), 1)
c.addConnection(("wheel", "face"),
                ("centerhole", "hole"),
                mode="hole")

c.inheritAllInterfaces("motor", prefix=None)
c.toYaml("library/Wheel.yaml")
