from svggen.api.component import Component

c = Component()

# BOX

c.addSubcomponent("cabin","Cabin", inherit=True, prefix=None)
c.addSubcomponent("boat","BoatBase")

c.addConstraint(("boat","length"), ("length", "depth"), "sum(x)")
c.addConstraint(("boat","width"), "width")
c.addConstraint(("boat","depth"), "width", "x/3.")
c.addConstraint(("boat","bow"), "length", "x/2.")
c.addConstraint(("boat","stern"), "length", "x/8.")

c.addConnection(("cabin", "portedge"), ("boat", "portedge"), angle=0)
c.addConnection(("cabin", "staredge"), ("boat", "staredge"), angle=0, tabWidth=10)

c.toYaml("library/Tug.yaml")
