from svggen.api.component import Component

c = Component()

# BOX

c.addParameter("n", 6)
c.addParameter("spacing", 25)

for i in range(3):
    c.addSubcomponent("boat%d"%i,"BoatBase", inherit=True, prefix=None)

    c.addSubcomponent("portsplit%d"%i,"SplitEdge")
    c.addSubcomponent("starsplit%d"%i,"SplitEdge")

    c.addConstraint(("portsplit%d"%i,"botlength"), ("length", "n"), "[x[0]]")
    c.addConstraint(("portsplit%d"%i,"toplength"), ("length", "n"), "[x[0]/(1.*x[1])] * x[1]")
    c.addConstraint(("starsplit%d"%i,"toplength"), ("length", "n"), "[x[0]]")
    c.addConstraint(("starsplit%d"%i,"botlength"), ("length", "n"), "[x[0]/(1.*x[1])] * x[1]")

    c.addConnection(("portsplit%d"%i, "botedge0"), ("boat%d"%i, "portedge"), angle=-90)
    c.addConnection(("starsplit%d"%i, "topedge0"), ("boat%d"%i, "staredge"), angle=-90)

for i in range(10):
    nm = "seat%d"%i
    c.addSubcomponent(nm, "Rectangle")
    c.addConstraint((nm, "l"), ("spacing", "n"), "(%d < x[1]) and x[0] or 0" % i)
    c.addConstraint((nm, "w"), ("length", "n"), "x[0]/(1.*x[1])")
    if (i % 2):
        c.addConnection(("starsplit0", "botedge%d" % i), (nm, "l"))
        c.addConnection(("portsplit1", "topedge%d" % i), (nm, "r"))
    else:
        c.addConnection(("starsplit1", "botedge%d" % i), (nm, "l"))
        c.addConnection(("portsplit2", "topedge%d" % i), (nm, "r"))

c.toYaml("library/Trimaran.yaml")
