
from svggen.api.component import Component

###################
# Component builder
###################

c = Component()

### Subcomponents used in this assembly
c.addSubcomponent("mount", "Cutout", inherit=False)
c.addSubcomponent("device", "TouchSensorDevice", inherit=False)
c.addSubcomponent("driver", "TouchSensorDriver", inherit=False)
c.addConstConstraint(('driver', 'drivenComponent'), 'device')

c.addParameter('controller')
c.addParameter('sensorControllerPin')

c.addConstConstraint(('mount', 'dx'), 6)
c.addConstConstraint(('mount', 'dy'), 4)
c.inheritInterface("mount", ("mount", "hole"))

c.addConstraint(('device', 'sensorSignal.controllerPin'), 'sensorControllerPin')
#
c.addConstraint(('device', 'controller'), 'controller')
c.addConstraint(('driver', 'controller'), 'controller')
#
#
# ### Exposed interfaces
c.inheritInterface("sensorSignal", ("device", "sensorSignal"))
c.inheritInterface("ground", ("device", "ground"))
c.inheritInterface("touched", ("driver", "touched"))

c.toYaml("library/TouchSensor.yaml")

